/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso.iso9660;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.filesystems.umdiso.iso9660.Iso9660File;

public class Iso9660Directory {
    private final List<Iso9660File> files;

    public Iso9660Directory(UmdIsoReader r, int directorySector, long directorySize) throws IOException {
        UmdIsoFile dataStream = new UmdIsoFile(r, directorySector, directorySize, null, null);
        this.files = new ArrayList<Iso9660File>();
        byte[] b = new byte[256];
        while (directorySize >= 1L) {
            int entryLength = dataStream.read();
            if (entryLength == 0) {
                --directorySize;
                continue;
            }
            directorySize -= (long)entryLength;
            int readLength = dataStream.read(b, 0, entryLength - 1);
            Iso9660File file = new Iso9660File(b, readLength, r.hasJolietExtension());
            this.files.add(file);
        }
        dataStream.close();
    }

    public Iso9660File getEntryByIndex(int index) throws ArrayIndexOutOfBoundsException {
        return this.files.get(index);
    }

    public int getFileIndex(String fileName) throws FileNotFoundException {
        int i = 0;
        for (Iso9660File file : this.files) {
            if (file.getFileName().equalsIgnoreCase(fileName)) {
                return i;
            }
            ++i;
        }
        throw new FileNotFoundException(String.format("File '%s' not found in directory.", fileName));
    }

    public String[] getFileList() throws FileNotFoundException {
        String[] list = new String[this.files.size()];
        int i = 0;
        for (Iso9660File file : this.files) {
            list[i] = file.getFileName();
            ++i;
        }
        return list;
    }
}

